/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.vw.base.DateHelper;
import filenet.vw.base.JVMSystemConstants;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.logging.Level;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Node;

public class Logger {
    private static String CONFIG_FILENAME = null;
    private static long CONFIG_FILELASTMODIFIED = -1L;
    private static String PARAMFILE_NAME = null;
    private static long loggingFileCheckInterval = 120000L;
    private static long lastTimeChecked = System.currentTimeMillis() - loggingFileCheckInterval;
    private static final String stars = "******************************************";
    private static String FQCN;
    private static Hashtable LOGGERS;
    private static Vector APPENDERS;
    private org.apache.log4j.Logger logger;
    private boolean checkAPPENDERs = false;
    private String m_name = null;
    private static final String newline = "\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(String propName) {
        String string;
        if (PARAMFILE_NAME == null) {
            Logger.checkFile();
        }
        if (PARAMFILE_NAME == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(PARAMFILE_NAME);
            VWXMLWrapper xmlParam = new VWXMLWrapper(in);
            Node loggerNode = VWXMLWrapper.getNodeNamed(xmlParam.getRootNode(), this.m_name);
            if (loggerNode == null) {
                String string2 = null;
                return string2;
            }
            string = VWXMLWrapper.getNodeValue(loggerNode, propName);
        }
        catch (Exception ex) {
            String string3 = null;
            return string3;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return string;
    }

    private static final String getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private static synchronized void checkFile() {
        long now = System.currentTimeMillis();
        if (now - lastTimeChecked < loggingFileCheckInterval) {
            return;
        }
        lastTimeChecked = now;
        if (CONFIG_FILENAME == null && (CONFIG_FILENAME = Logger.getPrivilegedSystemProperty("java.home")) != null) {
            File parentLib = new File(CONFIG_FILENAME, "lib");
            File f = new File(parentLib, "fnlog4j.properties");
            try {
                CONFIG_FILENAME = f.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
            f = new File(parentLib, "fnlog4j_params.xml");
            try {
                PARAMFILE_NAME = f.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (CONFIG_FILENAME != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    block4: {
                        block3: {
                            File f = new File(CONFIG_FILENAME);
                            if (!f.exists()) break block3;
                            long lastModified = f.lastModified();
                            if (CONFIG_FILELASTMODIFIED != -1L && lastModified <= CONFIG_FILELASTMODIFIED) break block4;
                            CONFIG_FILELASTMODIFIED = lastModified;
                            PropertyConfigurator.configure((String)CONFIG_FILENAME);
                            Enumeration loggerEnum = LOGGERS.elements();
                            while (loggerEnum.hasMoreElements()) {
                                Logger logger = (Logger)loggerEnum.nextElement();
                                if (logger.getLevel() != null) continue;
                                logger.setAdditive(true);
                            }
                            break block4;
                        }
                        if (CONFIG_FILELASTMODIFIED != -1L) {
                            CONFIG_FILELASTMODIFIED = -1L;
                            Enumeration loggerEnum = LOGGERS.elements();
                            while (loggerEnum.hasMoreElements()) {
                                Logger logger = (Logger)loggerEnum.nextElement();
                                if (logger.getLevel() != null) continue;
                                logger.setAdditive(false);
                            }
                        }
                    }
                    return null;
                }
            });
        }
    }

    public static String loggablePassword(String pw) {
        String lp = "";
        if (pw != null && pw.length() > 0) {
            int starLength = Math.min(pw.length(), stars.length());
            lp = pw.substring(0, 1) + stars.substring(1, starLength);
        }
        return lp;
    }

    protected static void setRootLoggerPerPELogLevel() {
        org.apache.log4j.Logger rl = org.apache.log4j.Logger.getRootLogger();
        String peLogLevel = Logger.getPrivilegedSystemProperty("PELogLevel");
        if (peLogLevel != null) {
            org.apache.log4j.Level l = Level.toLevel(peLogLevel);
            rl.setLevel(l);
            String peLogFileLayout = Logger.getPrivilegedSystemProperty("PELogFileLayout");
            if (peLogFileLayout == null) {
                peLogFileLayout = "%d{yyyy/MM/dd HH:mm:ss} [%t] %-5p %c{1} %x %m%n";
            }
            rl.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout(peLogFileLayout)));
            String peLogFile = Logger.getPrivilegedSystemProperty("PELogFile");
            if (peLogFile != null) {
                DailyRollingFileAppender appender = new DailyRollingFileAppender();
                appender.setName("PELogFile");
                appender.setFile(peLogFile);
                appender.setAppend(true);
                appender.setLayout((Layout)new PatternLayout(peLogFileLayout));
                appender.setThreshold((Priority)l);
                appender.activateOptions();
                rl.addAppender((Appender)appender);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installAppender(Appender a) {
        Vector vector = APPENDERS;
        synchronized (vector) {
            APPENDERS.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deInstallAppender(Appender a) {
        Vector vector = APPENDERS;
        synchronized (vector) {
            APPENDERS.remove(a);
        }
    }

    public static Iterator getAPPENDERSIterator() {
        return APPENDERS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAPPENDERS() {
        if (this.checkAPPENDERs || APPENDERS.size() == 0) {
            return;
        }
        for (Appender a : APPENDERS) {
            boolean alreadyThere = false;
            Category lParent = this.logger.getParent();
            while (!alreadyThere && lParent != null) {
                alreadyThere = lParent.getAppender(a.getName()) != null;
                if (alreadyThere) continue;
                lParent = lParent.getParent();
            }
            if (alreadyThere) continue;
            this.logger.addAppender(a);
        }
        Hashtable hashtable = LOGGERS;
        synchronized (hashtable) {
            for (Logger l : LOGGERS.values()) {
                org.apache.log4j.Logger loggerImpl = l.getLoggerImpl();
                if (l == this || !this.isDescendant((Category)loggerImpl)) continue;
                for (Appender a : APPENDERS) {
                    if (loggerImpl.getAppender(a.getName()) == null) continue;
                    loggerImpl.removeAppender(a.getName());
                }
            }
        }
        this.checkAPPENDERs = true;
    }

    private boolean isDescendant(Category l) {
        if (l == null) {
            return false;
        }
        if (this.getLoggerImpl().equals(l)) {
            return true;
        }
        return this.isDescendant(l.getParent());
    }

    public org.apache.log4j.Logger getLoggerImpl() {
        return this.logger;
    }

    public Logger(String name) {
        if (name == null || name.equals("root")) {
            this.logger = org.apache.log4j.Logger.getRootLogger();
            this.m_name = "root";
        } else {
            this.logger = org.apache.log4j.Logger.getLogger((String)name);
            this.m_name = name;
        }
        this.checkAPPENDERS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger;
        if (name == null) {
            name = "root";
        }
        if ((logger = (Logger)LOGGERS.get(name)) == null) {
            Hashtable hashtable = LOGGERS;
            synchronized (hashtable) {
                logger = (Logger)LOGGERS.get(name);
                if (logger == null) {
                    logger = new Logger(name);
                    LOGGERS.put(name, logger);
                }
            }
        }
        return logger;
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz.getName());
    }

    public static Logger getAnonymousLogger() {
        return Logger.getLogger("root");
    }

    public boolean isFinest() {
        this.checkAPPENDERS();
        Logger.checkFile();
        return this.isDebugEnabled();
    }

    public boolean isDebugEnabled() {
        Logger.checkFile();
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        Logger.checkFile();
        return this.logger.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        Logger.checkFile();
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    public boolean isErrorEnabled() {
        Logger.checkFile();
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.ERROR);
    }

    public boolean isFatalEnabled() {
        Logger.checkFile();
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.FATAL);
    }

    public boolean isEnabledFor(Priority p) {
        Logger.checkFile();
        return this.logger.isEnabledFor(p);
    }

    public void debug(String s) {
        this.debug(s, null);
    }

    public void debug(String s, Throwable t) {
        this.debug(FQCN, s, t);
    }

    public void debug(String fqcn, String s, Throwable t) {
        this.logger.log(fqcn, (Priority)org.apache.log4j.Level.DEBUG, (Object)s, t);
    }

    public void info(String s) {
        this.checkAPPENDERS();
        this.info(s, null);
    }

    public void info(String s, Throwable t) {
        this.info(FQCN, s, t);
    }

    public void info(String fqcn, String s, Throwable t) {
        this.logger.log(fqcn, (Priority)org.apache.log4j.Level.INFO, (Object)s, t);
    }

    public void warn(String s) {
        this.warn(s, null);
    }

    public void warn(String s, Throwable t) {
        this.warn(FQCN, s, t);
    }

    public void warn(String fqcn, String s, Throwable t) {
        this.logger.log(fqcn, (Priority)org.apache.log4j.Level.WARN, (Object)s, t);
    }

    public void error(String s) {
        this.error(s, null);
    }

    public void error(String s, Throwable t) {
        this.error(FQCN, s, t);
    }

    public void error(String fqcn, String s, Throwable t) {
        this.logger.log(fqcn, (Priority)org.apache.log4j.Level.ERROR, (Object)s, t);
    }

    public void fatal(String s) {
        this.fatal(s, null);
    }

    public void fatal(String s, Throwable t) {
        this.fatal(FQCN, s, t);
    }

    public void fatal(String fqcn, String s, Throwable t) {
        this.logger.log(fqcn, (Priority)org.apache.log4j.Level.FATAL, (Object)s, t);
    }

    public Enumeration getAllAppenders() {
        return this.logger.getAllAppenders();
    }

    public void finest(String className, String method, String message) {
        this.debug(className + "\t" + method + "\t" + message);
    }

    public void finest(String className, String method, String message, Object[] params) {
        if (this.isFinest()) {
            this.debug(className + "\t" + method + "\t" + message + ". Params=" + Logger.asString(params));
        }
    }

    public void finest(String message) {
        this.debug(message);
    }

    public void entering(String className, String method) {
        Logger.checkFile();
        this.finest(className, method, "ENTER");
    }

    public void entering(String className, String method, Object[] params) {
        Logger.checkFile();
        this.logger.log(FQCN, (Priority)org.apache.log4j.Level.DEBUG, (Object)(className + "\t" + method + "\t" + Logger.asString(params)), null);
        this.finest(className, method, "ENTER\t" + Logger.asString(params));
    }

    public void exiting(String className, String method, Object o) {
        Logger.checkFile();
        this.finest(className, method, "EXIT\t" + Logger.asString(o));
    }

    public void exiting(String className, String method) {
        Logger.checkFile();
        this.finest(className, method, "EXIT");
    }

    public void throwing(String className, String method, Throwable t) {
        this.debug(className, method + ":THROWING", t);
    }

    public void severe(String message) {
        Logger.checkFile();
        this.fatal(message);
    }

    public void severe(String className, String method, String message) {
        Logger.checkFile();
        this.fatal(message);
    }

    public void warning(String className, String method, String message) {
        Logger.checkFile();
        this.warn(message);
    }

    public void warning(String message) {
        Logger.checkFile();
        this.warn(message);
    }

    public void fine(String className, String method, String s) {
        Logger.checkFile();
        this.finest(className, method, s);
    }

    public void fine(String className, String method, String s, Object[] params) {
        this.finest(className, method, s, params);
    }

    public void fine(String s) {
        Logger.checkFile();
        this.finest(s);
    }

    public void finer(String className, String method, String s) {
        Logger.checkFile();
        this.finest(className, method, s);
    }

    public void finer(String className, String method, String s, Object[] params) {
        Logger.checkFile();
        this.finest(className, method, s + ".  Params=" + Logger.asString(params));
    }

    public void finer(String s) {
        Logger.checkFile();
        this.finest(s);
    }

    public void info(String className, String method, String s) {
        Logger.checkFile();
        this.info(s);
    }

    public void info(String className, String method, String s, Object[] params) {
        Logger.checkFile();
        this.info(s + " Params=" + Logger.asString(params));
    }

    public void log(Level level, String className, String method, String s) {
        Logger.checkFile();
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            this.logger.log(FQCN, (Priority)level, (Object)s, null);
        } else {
            this.logger.log(FQCN, (Priority)level, (Object)(className + "\t" + method + "\t" + s), null);
        }
    }

    public void log(Level level, String className, String method, String s, Throwable t) {
        Logger.checkFile();
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            this.logger.log(FQCN, (Priority)level, (Object)s, t);
        } else {
            this.logger.log(FQCN, (Priority)level, (Object)(className + "\t" + method + "\t" + s), t);
        }
    }

    public void log(Level level, String s, Throwable t) {
        Logger.checkFile();
        this.logger.log(FQCN, (Priority)level, (Object)s, t);
    }

    public void log(Level level, String s) {
        Logger.checkFile();
        this.logger.log(FQCN, (Priority)level, (Object)s, null);
    }

    public boolean isLoggable(Level level) {
        Logger.checkFile();
        return this.logger.isEnabledFor((Priority)level);
    }

    public org.apache.log4j.Level getLevel() {
        Logger.checkFile();
        return this.logger.getLevel();
    }

    public void setLevel(Level level) {
        this.logger.setLevel((org.apache.log4j.Level)level);
    }

    public void setLevel(org.apache.log4j.Level level) {
        this.logger.setLevel(level);
    }

    public void addHandler(Appender newAppender) {
        this.logger.addAppender(newAppender);
    }

    public void setAdditive(boolean b) {
        this.logger.setAdditivity(b);
    }

    private static boolean classIsPrimitive(Class cls) {
        return cls.isPrimitive() || cls.equals(Integer.class) || cls.equals(Long.class) || cls.equals(Byte.class) || cls.equals(Float.class) || cls.equals(Double.class) || cls.equals(Short.class) || cls.equals(Boolean.class) || cls.equals(String.class) || cls.equals(Date.class) || cls.equals(Byte.class);
    }

    public void logObject(String className, String methodName, String location, Object obj) {
        if (!this.isFinest()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(location).append("\t");
        Vector<Object> v = new Vector<Object>();
        if (obj != null) {
            v.add(obj);
        }
        Logger.inspectObject(obj, buf, v);
        v.clear();
        v = null;
        this.finest(className, methodName, buf.toString());
    }

    private static void inspectObject(Object obj, StringBuilder buf, Vector parentObjs) {
        if (obj == null) {
            buf.append("null");
            return;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            int len = Array.getLength(obj);
            if (len == 0) {
                buf.append("<empty>");
                return;
            }
            Class<?> itemClass = null;
            for (int k = 0; k < len; ++k) {
                Object item = Array.get(obj, k);
                if (item == null) continue;
                itemClass = item.getClass();
                break;
            }
            if (itemClass != null) {
                if (Logger.classIsPrimitive(itemClass)) {
                    buf.append(Logger.asString(obj));
                } else {
                    buf.append("[len=").append(len).append(",");
                    for (int i = 0; i < len; ++i) {
                        Object anItem = Array.get(obj, i);
                        if (!parentObjs.contains(anItem)) {
                            parentObjs.add(anItem);
                            Logger.inspectObject(Array.get(obj, i), buf, parentObjs);
                        } else {
                            buf.append("*SEEN*");
                        }
                        if (i >= len - 1) continue;
                        buf.append(",\n");
                    }
                    buf.append("]");
                }
            }
        } else {
            if (Logger.classIsPrimitive(cls)) {
                buf.append(obj);
                return;
            }
            String className = cls.getName();
            buf.append("<").append(className);
            try {
                cls.getDeclaredMethod("toString", new Class[0]);
                buf.append(" value=\"").append(obj).append("\"/>");
            }
            catch (NoSuchMethodException ex) {
                buf.append(">");
                Field[] fields = cls.getFields();
                int nFields = fields == null ? 0 : fields.length;
                for (int i = 0; i < nFields; ++i) {
                    buf.append(" ").append(fields[i].getName()).append("=");
                    try {
                        Object fldObj = fields[i].get(obj);
                        if (fldObj == null) {
                            buf.append("null");
                        } else if (Logger.classIsPrimitive(fldObj.getClass())) {
                            buf.append(Logger.asString(fldObj));
                        } else if (!parentObjs.contains(fldObj)) {
                            parentObjs.add(fldObj);
                            Logger.inspectObject(fldObj, buf, parentObjs);
                        } else {
                            buf.append("*SEEN*");
                        }
                    }
                    catch (Exception e) {
                        buf.append("INACCESSIBLE");
                    }
                    if (i >= nFields - 1) continue;
                    buf.append(",");
                }
                buf.append("</>");
            }
        }
    }

    public static String asString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isArray()) {
            Object obja = null;
            StringBuilder b = new StringBuilder();
            int len = Array.getLength(obj);
            if (len == 0) {
                return "";
            }
            b.append("[len=").append(len).append(", ");
            for (int i = 0; i < len; ++i) {
                obja = Array.get(obj, i);
                if (obja != null) {
                    b.append(Logger.asString(obja));
                } else {
                    b.append("null");
                }
                if (i >= len - 1) continue;
                b.append(",");
            }
            b.append("]");
            return b.toString();
        }
        return obj.toString();
    }

    public static String count(Object obj) {
        if (obj == null) {
            return "null";
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            int len = Array.getLength(obj);
            return objClass.getName() + " has " + Integer.toString(len) + " items";
        }
        if (obj instanceof Hashtable) {
            return "Hashtable has " + Integer.toString(((Hashtable)obj).size()) + " items";
        }
        return "NONNULL obj";
    }

    private static void traceThreadInfo(StringBuilder buf, Thread cT) {
        if (cT == null) {
            buf.append("Null Thread?");
            return;
        }
        buf.append(cT).append(cT.isDaemon() ? "" : " not").append(" daemon").append(newline).append("ClassLoader=").append(cT.getContextClassLoader());
        buf.append(newline).append("Stack Trace: ");
        StackTraceElement[] st = cT.getStackTrace();
        int nSt = st == null ? 0 : st.length;
        for (int i = 0; i < nSt; ++i) {
            buf.append(st[i].toString()).append(newline);
        }
        buf.append(newline);
    }

    public static int CountThread() {
        ThreadGroup tg;
        Thread cT = Thread.currentThread();
        for (tg = cT.getThreadGroup(); tg != null && tg.getParent() != null; tg = tg.getParent()) {
        }
        return tg == null ? 0 : tg.activeCount();
    }

    public static String traceSystem() {
        StringBuilder buf = new StringBuilder();
        buf.append("STATE OF THE SYSTEM at ");
        buf.append(DateHelper.convertDateToUTCString(new Date())).append(newline);
        try {
            ThreadGroup tg;
            Runtime r = Runtime.getRuntime();
            buf.append(Logger.traceProperties("Logger.traceSystem"));
            buf.append("\nSystem Free= ").append(r.freeMemory()).append(", Total= ").append(r.totalMemory());
            Thread cT = Thread.currentThread();
            buf.append("\n\nCurrent Thread=");
            Logger.traceThreadInfo(buf, cT);
            buf.append("\n\nAll Threads:=\n");
            for (tg = cT.getThreadGroup(); tg != null && tg.getParent() != null; tg = tg.getParent()) {
            }
            int nThread = tg.activeCount();
            Thread[] ts = new Thread[nThread];
            tg.enumerate(ts, true);
            for (int i = 0; i < nThread; ++i) {
                buf.append("\nThread [").append(i).append("]=");
                Logger.traceThreadInfo(buf, ts[i]);
            }
        }
        catch (Throwable e) {
            buf.append(e);
        }
        return buf.toString();
    }

    public static String traceProperties(String loc) {
        StringBuilder buf = new StringBuilder();
        buf.append(newline).append(loc).append(" -- System properties:\n");
        try {
            Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperties();
                }
            });
            if (sysProps != null) {
                Enumeration<Object> keys = sysProps.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    buf.append(key).append("=").append(sysProps.get(key)).append(newline);
                }
            }
        }
        catch (Throwable t) {
            buf.append("Failed to get System properties.  ex=").append(t.getMessage());
        }
        try {
            InitialContext ctx = new InitialContext();
            Hashtable<?, ?> h = null;
            h = ctx.getEnvironment();
            buf.append("\nJNDI Properties:\n");
            if (h != null) {
                Enumeration<?> keys = h.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    buf.append(key).append("=").append(h.get(key)).append(newline);
                }
            } else {
                buf.append("Failed to get JNDI environment????");
            }
        }
        catch (Throwable t) {
            buf.append("Failed to get JNDI environment - Ex=").append(t.getMessage());
        }
        return buf.toString();
    }

    static {
        loggingFileCheckInterval = JVMSystemConstants.GetLongPrivilegedSystemPropertyWithDefault("filenet.vw.base.logging.checkfile.interval", 60000L);
        Logger.setRootLoggerPerPELogLevel();
        FQCN = Logger.class.getName() + ".";
        LOGGERS = new Hashtable(10);
        APPENDERS = new Vector(2);
    }
}

